--
-- kolosSzK
-- This is the specialization for combines
--
-- @author  Stefan Geiger
-- @date  30/11/08
--
-- Copyright (C) GIANTS Software GmbH, Confidential, All Rights Reserved.

kolosSzK = {};

function NIVACK5M.prerequisitesPresent(specializations)
	return SpecializationUtil.hasSpecialization(Motorized, specializations);
end;

function NIVACK5M:load(xmlFile)
	
		self.xPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.display#posX"), 0.7543);
	self.yPos = Utils.getNoNil(getXMLFloat(xmlFile,  "vehicle.display#posY"), 0.1715);
	self.hudBarWidth = 0.205;
	self.overlay = Overlay:new("hudESLOverlay", Utils.getFilename("display_hud.png", self.baseDirectory), self.xPos, self.yPos, 0.2371, 0.039525);
	self.overlayBg = Overlay:new("hudESLBackground", Utils.getFilename("display_bg.png", self.baseDirectory), self.xPos, self.yPos, 0.2371, 0.039525);
	self.overlayBar = Overlay:new("hudESLbar", Utils.getFilename("display_bar.png", self.baseDirectory), self.xPos + 0.123, self.yPos + 0.0085714, 0.205, 0.02190);
	self.lock = Overlay:new("hudESLlock", Utils.getFilename("$dataS/menu/locked_icon.png", self.baseDirectory), self.xPos + 0.12581, self.yPos + 0.0095, 0.015, 0.02);
		
self.controlpath = Utils.getFilename("Texstures/info.png", self.baseDirectory);

self.hudNivaWidth = 0.700;
    self.hudNivaHeight = 0.320;
    self.hudNivaPoxX = 0;
    self.hudNivaPoxY = 0;
    self.hudNivaOverlay = Overlay:new("hudNiva", self.controlpath, self.hudNivaPoxX, self.hudNivaPoxY, self.hudNivaWidth, self.hudNivaHeight);

numparts = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts#count"), 0);
	self.parts = {};
    for i=1, numparts do
        local partnamei = string.format("vehicle.parts.part%d", i);
        self.parts[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index"));
        setVisibility(self.parts[i], false);
    end;
	self.partsActive = false;
	
	numparts3 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts3#count"), 0); 
 self.parts3 = {}; 
 for i=1, numparts3 do 
 local partnamei = string.format("vehicle.parts3.part%d", i); 
 self.parts3[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index")); 
 setVisibility(self.parts3[i], false); 
 end; 
 	
	numparts4 = Utils.getNoNil(getXMLInt(xmlFile, "vehicle.parts4#count"), 0); 
 self.parts4 = {}; 
 for i=1, numparts4 do 
 local partnamei = string.format("vehicle.parts4.part%d", i); 
 self.parts4[i] = Utils.indexToObject(self.components, getXMLString(xmlFile, partnamei .. "#index")); 
 setVisibility(self.parts4[i], false); 
 end;
 self.parts3Active = false;

	-- Straw Active Boolean
    self.strawActive = true;

self.dumParticle = {};
    local i = 0;
    while true do
        local namei = string.format("vehicle.NIVACK5M.dum.dum(%d)", i);
		local nodei = Utils.indexToObject(self.components, getXMLString(xmlFile, namei .. "#index"));
		if nodei == nil then
			break;
		end; 
        Utils.loadParticleSystem(xmlFile, self.dumParticle, namei, nodei, false, nil, self.baseDirectory)		
		Utils.setEmittingState(self.dumParticle,false)
		self.particleSystemdisableTime = 0;
		i = i +1;		
    end;

	self.shaderParts = {};
	local i=0;
	while true do
		local partName = string.format("vehicle.shaderParts.shaderPart(%d)", i);
		local part = {};
		local nodeString = getXMLString(xmlFile, partName .. "#index");
		if nodeString == nil then
			break;
		else
			part.index = Utils.indexToObject(self.components, nodeString);
			part.offSpeed = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#offSpeed"), 90000000000);
			part.onSpeed = Utils.getNoNil(getXMLFloat(xmlFile, partName .. "#onSpeed"), 1.0);
			setShaderParameter(part.index, "partScale", part.offSpeed, 1, 0, 0, false);
			local isVisibility = getXMLString(xmlFile, partName .. "#setVisibilityTurnOn");
			if isVisibility ~= "" and isVisibility == "true" then
				part.visibility = false;
				setVisibility(part.index, part.visibility);
			end;
			table.insert(self.shaderParts, part);
		end;
		i = i+1;
	end;

    self.keys = {};
    local i=0;
    while true do
        local baseName = string.format("vehicle.keys.input(%d)", i);
        local inputName = getXMLString(xmlFile, baseName.. "#name");
        if inputName == nil then
            break;
        end;
        local inputKey = getXMLString(xmlFile, baseName.. "#key");
        if Input[inputKey] == nil then
            print("Error: invalid key '" .. inputKey .. "'  for input event '" .. inputName .. "'");
            break;
        end;
        self.keys[inputName] = Input[inputKey];
        i = i+1;
    end;

local rotationPartNoderuchnik = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#index"));

    if rotationPartNoderuchnik ~= nil then
        self.rotationPartruchnik = {};
        self.rotationPartruchnik.node = rotationPartNoderuchnik;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#minRot"));
        self.rotationPartruchnik.minRot = {};
        self.rotationPartruchnik.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#maxRot"));
        self.rotationPartruchnik.maxRot = {};
        self.rotationPartruchnik.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchnik.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchnik.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchnik.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#rotTime"), 2)*1000;
        self.rotationPartruchnik.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchnik#touchRotLimit"), 10));
    end;

		self.shnek = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.NIVACK5M.shnek#index"));
		self.shnek1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.NIVACK5M.shnek1#index"));

     local rotationPartNoderuchag2 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#index"));
    if rotationPartNoderuchag2 ~= nil then
        self.rotationPartruchag2 = {};
        self.rotationPartruchag2.node = rotationPartNoderuchag2;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.rotationPartruchag2#minRot"));
        self.rotationPartruchag2.minRot = {};
        self.rotationPartruchag2.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag2.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag2.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#maxRot"));
        self.rotationPartruchag2.maxRot = {};
        self.rotationPartruchag2.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag2.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag2.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchag2.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#rotTime"), 2)*1000;
        self.rotationPartruchag2.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag2#touchRotLimit"), 10));
    end;

     local rotationPartNoderuchag1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#index"));
    if rotationPartNoderuchag1 ~= nil then
        self.rotationPartruchag1 = {};
        self.rotationPartruchag1.node = rotationPartNoderuchag1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.rotationPartruchag1#minRot"));
        self.rotationPartruchag1.minRot = {};
        self.rotationPartruchag1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#maxRot"));
        self.rotationPartruchag1.maxRot = {};
        self.rotationPartruchag1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartruchag1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartruchag1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartruchag1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#rotTime"), 2)*1000;
        self.rotationPartruchag1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.ruchag1#touchRotLimit"), 10));
    end;


     local rotationPartNodedver1 = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#index"));
    if rotationPartNodedver1 ~= nil then
        self.rotationPartdver1 = {};
        self.rotationPartdver1.node = rotationPartNodedver1;

        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.rotationPartdver1#minRot"));
        self.rotationPartdver1.minRot = {};
        self.rotationPartdver1.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdver1.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdver1.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#maxRot"));
        self.rotationPartdver1.maxRot = {};
        self.rotationPartdver1.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.rotationPartdver1.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.rotationPartdver1.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.rotationPartdver1.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#rotTime"), 2)*1000;
        self.rotationPartdver1.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.dver1#touchRotLimit"), 10));
    end;

       self.ventelator1 = Utils.indexToObject(self.components, getXMLString(xmlFile, "vehicle.NIVACK5M.ventelator1#index"));
	   
    local attachNode = Utils.indexToObject(self.rootNode, getXMLString(xmlFile, "vehicle.NIVACK5M.attach#index"));
    if attachNode ~= nil then
        self.attach = {};
        self.attach.node = attachNode;
        local x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#minRot"));
        self.attach.minRot = {};
        self.attach.minRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.minRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.minRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        x, y, z = Utils.getVectorFromString(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#maxRot"));
        self.attach.maxRot = {};
        self.attach.maxRot[1] = Utils.degToRad(Utils.getNoNil(x, 0));
        self.attach.maxRot[2] = Utils.degToRad(Utils.getNoNil(y, 0));
        self.attach.maxRot[3] = Utils.degToRad(Utils.getNoNil(z, 0));

        self.attach.rotTime = Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#rotTime"), 2)*1000;
        self.attach.touchRotLimit = Utils.degToRad(Utils.getNoNil(getXMLString(xmlFile, "vehicle.NIVACK5M.attach#touchRotLimit"), 10));
    end;	
	
end;


function NIVACK5M:mouseEvent(posX, posY, isDown, isUp, button)
end;

function NIVACK5M:keyEvent(unicode, sym, modifier, isDown)

	if isDown and sym == Input.KEY_u then 
	  self.partsActive = not self.partsActive;
	end;
	
	if isDown and sym == Input.KEY_y then 
		self.parts3Active = not self.parts3Active;
	end;

	if isDown and sym == self.keys.ruchnik then
		self.handbrake = not self.handbrake
	end;

	if sym == Input.KEY_pagedown then
		self.attachMax = isDown;
	end;
	if sym == Input.KEY_pageup then
		self.attachMin = isDown;
	end;

end;

function NIVACK5M:update(dt)

	
	--if self.inrange then
		--	if InputBinding.hasEvent (InputBinding.shnekOtkr) then
			--	self.shnekOtkr = not self.shnekOtkr;
		--	end;
	--end;
	
			if InputBinding.hasEvent (InputBinding.INFOHUD2) then
				self.bcActive = not self.bcActive;
			end;

if self.partsActive then
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive);
		end;
	        else
		for i=1, numparts do
			setVisibility(self.parts[i], self.partsActive, false);
	    end;
	end;
	   if self.parts3Active then
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active);
		end;
	        else
		for i=1, numparts3 do
			setVisibility(self.parts3[i], self.parts3Active, false);
	    end;	
    end;
		   if self.parts4Active then
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active);
		end;
	        else
		for i=1, numparts4 do
			setVisibility(self.parts4[i], self.parts4Active, false);
	    end;	
    end;

	
if self.inrange then
	if InputBinding.hasEvent (InputBinding.Shitok_niva) then
		self.parts4Active = not self.parts4Active;
	end;
end;
	
	if self.inrange then
		if self.parts4Active then
			g_currentMission:addHelpButtonText(g_i18n:getText("Shitok_niva_n1"), InputBinding.Shitok_niva);
		else
			g_currentMission:addHelpButtonText(g_i18n:getText("Shitok_niva_n2"), InputBinding.Shitok_niva);
		end;
	end;
	
 -- Check for input
	if self:getIsActive() then
		
		-- Check if straw is enabled
        if not self.strawActive then
		    self.strawEmitState = false;
			self.strawEnableTime = nil;
			self.chopperActivated = true;
			self.chopperBlind = nil;
					
            -- Enable chopper particle system					
			if self.lastArea > 0 then
			    if self.chopperActivated then
                    if self.chopperEnableTime == nil then
                        self.chopperEnableTime = self.time + self.chopperToggleTime;
                    else
                        self.chopperDisableTime = nil;
                    end;
                    disableChopperEmit = false;
			    end;
			
			    -- Chopper starting delay
			    if self.chopperEnableTime ~= nil and self.chopperEnableTime <= self.time then
			
                    self.currentChopperParticleSystem = self.chopperParticleSystems[self.currentGrainTankFruitType];
			
                    if self.currentChopperParticleSystem == nil then
                        self.currentChopperParticleSystem = self.defaultChopperParticleSystem;
                    end;
                    Utils.setEmittingState(self.currentChopperParticleSystem, true);
				
			    end;
			end;	
	    elseif self.strawActive then
		    self.chopperBlind = self.backupChopperBlind;
		end;
    end;

if self.rotationPartruchnik  ~= nil then
		local x, y, z = getRotation(self.rotationPartruchnik .node);
		local rot = {x,y,z};
		local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchnik.maxRot, self.rotationPartruchnik.minRot, 3, self.rotationPartruchnik.rotTime, dt, not self.rotationMaxruchnik);
		setRotation(self.rotationPartruchnik .node, unpack(newRot));
	end;

	if self.handbrake then
		self.motor.backwardGearRatio = 0;
		self.motor.forwardGearRatios = {0, 0, 0};
		self.motor.brakeForce = 100;	
		self.rotationMaxruchnik = true;
	else
		self.motor.backwardGearRatio = 2.8;
		self.motor.forwardGearRatios = {3.5, 3.5, 3.5};
		self.motor.brakeForce = 7;	
		self.rotationMaxruchnik = false;
	end;

	if self.pipeIsUnloading then
	self:setAnimationTime(3, self.animationParts[3].animDuration);	
	else
		self:setAnimationTime(3, self.animationParts[3].offSet);
	end;
	
	if self.pipeIsUnloading then
		rotate(self.shnek, dt*0.005, 0, 0 );	
		rotate(self.shnek1, dt*0.005, 0, 0 );	
	end;

	    if self.rotationPartruchag2 ~= nil then
		   local x, y, z = getRotation(self.rotationPartruchag2.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchag2.maxRot, self.rotationPartruchag2.minRot, 3, self.rotationPartruchag2.rotTime, dt, not self.rotationMaxruchag2);
		   setRotation(self.rotationPartruchag2.node, unpack(newRot));
        end;

		Utils.setEmittingState(self.dumParticle, self.dum);
		
		if self.isThreshing then
		self.dum = true;
		self.rotationMaxruchag1 = true;
		self.rotationMaxruchag2 = true;
		else
		self.dum = false;
		self.rotationMaxruchag1 = false;
		self.rotationMaxruchag2 = false;
		end;
		
		
	for cutter,implement in pairs(self.attachedCutters) do
	
        if cutter.reelStarted then
			if cutter.lastArea > 0 then 
				self.nivapunActive1 = true;
			else
				self.nivapunActive1 = false;
			end;
			
		end;
	end;
		
		--if self.isThreshing then
		--self.nivapunActive = true;
		--else
		--self.nivapunActive = false;
		--end;
		
	if self.isEntered then
		if InputBinding.isPressed(InputBinding.okno_nivaO) then
			self:setAnimationTime(5, self.animationParts[5].currentPosition+(self.animationParts[5].offSet+dt), false);
		elseif InputBinding.isPressed(InputBinding.okno_nivaZ) then
			self:setAnimationTime(5, self.animationParts[5].currentPosition-(self.animationParts[5].offSet+dt), false);
		end;
	end;
	
	    if self.rotationPartruchag1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartruchag1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartruchag1.maxRot, self.rotationPartruchag1.minRot, 3, self.rotationPartruchag1.rotTime, dt, not self.rotationMaxruchag1);
		   setRotation(self.rotationPartruchag1.node, unpack(newRot));
        end;

if self.inrange or self.isEntered then
	if InputBinding.hasEvent(InputBinding.dver1_niva) then
		self.rotationMaxdver1 = not self.rotationMaxdver1;
	end;  
end; 

	    if self.rotationPartdver1 ~= nil then
		   local x, y, z = getRotation(self.rotationPartdver1.node);
		   local rot = {x,y,z};
		   local newRot = Utils.getMovedLimitedValues(rot, self.rotationPartdver1.maxRot, self.rotationPartdver1.minRot, 3, self.rotationPartdver1.rotTime, dt, not self.rotationMaxdver1);
		   setRotation(self.rotationPartdver1.node, unpack(newRot));
        end;

	if self.isMotorStarted then
         		rotate(self.ventelator1, dt*0.03, 0, 0 );		
	end;

	local doRotate = self.attachMax or self.attachMin 
	if self.attach ~= nil and doRotate then
        	local x, y, z = getRotation(self.attach.node);		
        	local rot = {x,y,z};
        	local newRot = Utils.getMovedLimitedValues(rot, self.attach.maxRot, self.attach.minRot, 3, self.attach.rotTime, dt, not self.attachMax);
        	setRotation(self.attach.node, unpack(newRot));
	end;  

	
	if self.setAnimationTime ~= nil then
		if self.isThreshing then
			self:setAnimationTime(1, 1);
			self:setAnimationTime(4, 1);
		else
			self:setAnimationTime(1, 0);
			self:setAnimationTime(4, 0);
		end;
	end;

	if self.setAnimationTime ~= nil then
		if self.isMotorStarted then
			self:setAnimationTime(2, 1);
		else
			self:setAnimationTime(2, 0);
		end;
	end;
	
end;

function NIVACK5M:updateTick(dt)

if self.isThreshing then
		for k, part in pairs(self.shaderParts) do
			setShaderParameter(part.index, "partScale", part.onSpeed, 1, 0, 0, false);
		end;
	else
		for k, part in pairs(self.shaderParts) do
			setShaderParameter(part.index, "partScale", part.offSpeed, 1, 0, 0, false);
		end;
	end;	

if g_currentMission.player ~= nil then
		-- Getting the distance between the player and the implement 
		local nearestDistance = 4.0; --max distance allowed
		local px, py, pz = getWorldTranslation(self.rootNode); 
		local vx, vy, vz = getWorldTranslation(g_currentMission.player.rootNode);
		local distance = Utils.vector3Length(px-vx, py-vy, pz-vz);	
		if distance < nearestDistance then
			self.inrange = true; 
		else
			self.inrange = false; 
		end;
end;
end;

function NIVACK5M:draw()

self.overlayBg:render();
	
	self.overlayBar.width = self.hudBarWidth * math.min(1, (self.grainTankFillLevel * 100 / self.grainTankCapacity)/195);	
    setOverlayUVs(self.overlayBar.overlayId, 0, 0.05, 0, 1, math.min(1, (self.grainTankFillLevel * 100 / self.grainTankCapacity)/195), 0.05, math.min(1, (self.grainTankFillLevel * 100 / self.grainTankCapacity)/195), 1);
	self.overlayBar:render();
	
	self.overlay:render();
	setTextBold(true);
	setTextAlignment(RenderText.ALIGN_LEFT);
	setTextColor(0, 0, 0, 1);
    renderText(self.xPos + 0.136, self.yPos + 0.007, 0.02, text);	
	setTextColor(1, 1, 1, 1);
	renderText(self.xPos + 0.136, self.yPos + 0.010, 0.02, text);	

if self.isEntered then
 	 if self.hudNivaOverlay ~= nil then
  if self.bcActive then
    self.hudNivaOverlay:render();
  end;
end;
		if self.bcActive then	
			g_currentMission:addExtraPrintText("Key 0: INFO ON");
		else
			g_currentMission:addExtraPrintText("Key 0: INFO Off");
		end;  
end;
end;


function NIVACK5M:onLeave()

		self.rotationMaxdver1 = true;

end;

function NIVACK5M:delete()

end;

function key_Texstures(key)
    if key ~= nil then 
	    local keyname = "";
	    if key > 32 and key < 123 then
	    	keyname = string.upper(string.char(key));
	    elseif key > 255 and key < 266 then
	    	keyname = "NUM "..string.char(key-208);
	    else 
	    	keyname = "";
	    end;
	    return(keyname);
	  end;
end;

function NIVACK5M:attachImplement(implement)
		

      local object = implement.object;
      if object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
			self.strawActive = false;
      end;
  end;
  
function NIVACK5M:detachImplement(implementIndex)
      local object = self.attachedImplements[implementIndex].object;
      if object.attacherJoint.jointType == Vehicle.JOINTTYPE_IMPLEMENT then
	  	self.strawActive = true;
      end;
  end;

function NIVACK5M:validateAttacherJoint(implement, jointDesc, dt)
    return true;
end;